*Computation of between-class inequality according to Theil index and Gini

*Tim Goedemé, 27/04/2021


/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z;
https://timgoedeme.com/tools/esec-in-eu-silc/



*/

*globals IS and SK dropped from list of countries

global place1 A:\Stata files\Oxfiles\EU-SILC\Cross\2020-04\
global place2 C:\Users\tgoedeme\Dropbox\Publicaties\2021\Between-class inequality\Estimations\Between-MLD Gender\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK

*Estimations - 9 classes ONLY EU-SILC 2018
**!! dentropyg produces wrong subpopulation share estimates when ineligible observations are not deleted from the dataset !!
** Therefore, ineligible observations must be dropped.

cap mat drop results	
foreach ctry of global countries {
	di "`ctry'", _continue
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars2.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			drop if sub==0 | esec08==. | earns2<=0
				
			cap mat drop tempmat
			
			forvalues t = 0(1)2 {
				cap mat drop tempmat`t'
				dentropyg earns2, hgroup(esec08) theta(`t')
				local tot`t'=r(total)
				local w`t'=r(within)
				local b`t' = r(between)
				mat def tempmat`t' = `tot`t'', `w`t'', `b`t''
			}
			mat def tempmat = tempmat0, tempmat1, tempmat2
			mat def results = nullmat(results) \ tempmat
			
		}
	}
}
mat rownames results = ${countries}
mat colnames results = t0 w0 b0 t1 w1 b1 t2 w2 b2
mat li results


*Gini (with adjusted diginig command so that results are stored in r

cap mat drop results	
foreach ctry of global countries {
	di "`ctry'", _continue
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars2.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			drop if sub==0 | esec08==. | earns2<=0
				
			cap mat drop tempmat
			diginig earns2, hgroup(esec08)
			mat def tempmat = r(total), r(within), r(between), r(overlap)
			mat def results = nullmat(results) \ tempmat
			
		}
	}
}
mat rownames results = ${countries}
mat colnames results = Gini within between overlap
mat li results


